/* SUPERNOVA
2004 by Celso Riva
*/

#include	"main.h"
#include	<stdio.h>

bool Interactive_GUI=false;
bool Show_XY=false;

bool StartGame=false;
bool Options=false;
char buyurl[256]; //allocate a buffer of 256 chars
bool Buynow=false;
bool isOnlineScores=false;


KFont fontTable[] = {
                  { 'A',0,0,9,10,10,11 } ,
                  { 'B',10,0,18,10,9,11 } ,
                  { 'C',19,0,27,10,9,11 } ,
                  { 'D',28,0,37,10,10,11 } ,
                  { 'E',38,0,45,10,8,11 } ,
                  { 'F',46,0,53,10,8,11 } ,
                  { 'G',54,0,63,10,10,11 } ,
                  { 'H',64,0,73,10,10,11 } ,
                  { 'I',75,0,78,10,4,11 } ,
                  { 'J',79,0,86,10,8,11 } ,
                  { 'K',87,0,95,10,9,11 } ,
                  { 'L',96,0,103,10,8,11 } ,
                  { 'M',104,0,115,10,12,11 } ,
                  { 'N',116,0,124,10,9,11 } ,
                  { 'O',0,12,10,22,11,11 } ,
                  { 'P',11,12,19,22,9,11 } ,
                  { 'Q',20,12,30,24,11,13 } ,
                  { 'R',31,12,39,22,9,11 } ,
                  { 'S',40,12,48,22,9,11 } ,
                  { 'T',49,12,58,22,10,11 } ,
                  { 'U',59,12,68,22,10,11 } ,
                  { 'W',69,12,80,22,12,11 } ,
                  { 'V',81,12,90,22,10,11 } ,
                  { 'X',91,12,100,22,10,11 } ,
                  { 'Y',101,12,110,22,10,11 } ,
                  { 'Z',111,12,120,22,10,11 } ,
                  { 'b',8,24,15,34,8,11 } ,
                  { 'd',24,24,31,34,8,11 } ,
                  { 'f',40,24,46,34,7,11 } ,
                  { 'h',54,24,61,34,8,11 } ,
                  { 'i',63,24,66,34,4,11 } ,
                  { 'j',67,24,72,36,6,13 } ,
                  { 'k',73,24,80,34,8,11 } ,
                  { 'l',82,24,85,34,4,11 } ,
                  { 'a',0,24,7,34,8,11 } ,
                  { 'c',16,24,23,34,8,11 } ,
                  { 'e',32,24,39,34,8,11 } ,
                  { 'g',46,24,53,36,8,13 } ,
                  { 'm',86,24,97,34,12,11 } ,
                  { 'n',98,24,105,34,8,11 } ,
                  { 'o',106,24,114,34,9,11 } ,
                  { 'p',115,24,122,36,8,13 } ,
                  { 't',22,36,27,46,6,11 } ,
                  { '!',91,36,94,46,4,11 } ,
                  { '?',95,36,102,46,8,11 } ,
                  { 'q',0,36,7,48,8,13 } ,
                  { 'r',8,36,14,46,7,11 } ,
                  { 's',15,36,21,46,7,11 } ,
                  { 'u',28,36,35,46,8,11 } ,
                  { 'w',36,36,47,46,12,11 } ,
                  { 'v',48,36,55,46,8,11 } ,
                  { 'x',56,36,63,46,8,11 } ,
                  { 'y',64,36,71,48,8,13 } ,
                  { 'z',72,36,78,46,7,11 } ,
                  { ':',104,36,107,46,4,11 } ,
                  { '.',80,36,83,46,4,11 } ,
                  { ',',85,36,89,47,5,12 } ,
                  { '0',0,48,8,58,9,11 } ,
                  { '1',10,48,14,58,5,11 } ,
                  { '2',16,48,24,58,9,11 } ,
                  { '3',25,48,33,58,9,11 } ,
                  { '4',34,48,42,58,9,11 } ,
                  { '5',43,48,51,58,9,11 } ,
                  { '6',52,48,60,58,9,11 } ,
                  { '7',61,48,69,58,9,11 } ,
                  { '8',70,48,78,58,9,11 } ,
                  { '9',79,48,87,58,9,11 } ,
                  { '<',89,48,95,58,7,11 } ,
                  { '>',97,48,103,58,7,11 } ,
                  { '$',0,115,14,127,14,13 } ,
                  { '"',1,60,7,71,7,12 } ,
				  { '\'',1,60,4,71,5,12 } ,
                  { '(',36,60,41,72,6,13 } ,
                  { ')',42,60,47,72,6,13 } ,
                  { '%',17,60,27,72,11,14 } ,
                  { '/',29,60,35,72,7,13 } ,
                  { '+',56,60,63,72,8,13 } ,
                  { '=',48,60,55,72,8,13 } ,
                  { ' ',1,100,8,108,8,8 } ,
                  { '-',64,60,70,72,7,13 } ,
                  { '',0,75,8,85,8,12 } ,
                  { '',9,75,17,85,8,12 } ,
                  { '',18,75,24,85,8,12 } ,
                  { '',30,75,38,85,9,12 } ,
                  { '',40,75,50,85,11,12 } ,
                  { '',52,75,60,85,11,12 } ,
                  { '',62,75,67,85,7,12 } ,
                  {0,0,0,0,0,0,0}   //must end by a 0 character !
} ;

KFont fontTablePtr[128]; 

//callback where KEvents will be delivered
bool		ourOwnEventCallback( KEvent	*eventPtr ) ;

//Windows entry point
#ifdef WIN32								
int WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPreInst, 	LPSTR lpszCmdLine, 		int nCmdShow )
#else
int main (void)
#endif
{
	KMiscTools::initMiscTools();
#ifndef WIN32	
	KMiscTools::setFileSource( true ) ;
#endif	
	KIniReader *iniReader ;
	char s[256];
	iniReader = new KIniReader ;
	iniReader->setIni( KMiscTools::makeFilePath( "buy.ini" )) ;
	//read buy URL
	iniReader->getString( "BUY" , "URL" , buyurl , 255 ) ;
	delete iniReader;
	
	Timer = KMiscTools::getMilliseconds() ;
	//default medium difficulty
	GV.Difficulty=2;GV.StoryLevelRed=1;GV.StoryLevelBlue=11;GV.WeaponDMG=2;

	FILE	*f;
	f=fopen(KMiscTools::makeFilePath("prefs"),"rb");
	if (f != NULL)
	{
		fread(&GV,sizeof(GV_t),1,f);
		fclose(f);
	}
	GV.Bought=false;

	//check code
	if (Loadacode())
	{
		GV.Bought=true;
	}
	KInput::hidePointer( ) ;

	//Load Sounds
	LoadSounds();
	
	srand(KMiscTools::getMilliseconds() );
	short	mx,my; 

	_snprintf(s,64,GameName,KMiscTools::getYear());

	//launcher
	gameWindow = new KWindow ;
	if ( gameWindow == NULL )		
	{
		//uh oh a problem occured!
		return 0 ;
	}
	if ( gameWindow->createGameWindow( 400,300,-1,true,s ) == false )
	{
		//sorry couldn't create the window	
		delete gameWindow ;	
		return 0 ;
	}
	if ( SCR_INIT( ) == false )
	{
		//an error occurred
		delete gameWindow ;	
		return 0 ;
	}

 	GameInit();

	//loads the font and initialize the table
	InitFont();
	LoadPointer();
	KWindow::setPTKCallBack( ourOwnEventCallback ) ; 

	do
	{

		KGraphic::setDefaultWorldView( ) ; 

		mx = KInput::getMouseX( ) ;
		my = KInput::getMouseY( ) ;
		if ( mx > 0 && mx < 400 && my > 0 && my < 300 )
		{
			KInput::hidePointer( ) ;
		}
		else
		{
			KInput::showPointer( ) ;		
		}
		
		if ( KInput::isPressed( K_VK_F12 ) == ISDOWN )
			KGraphic::saveBackBuffer( KMiscTools::makeFilePath( "screenshot.jpg" ), 1 ) ;

		if ( KInput::isPressed( K_VK_ESCAPE ) == ISDOWN )
		{
			KInput::waitForKeyRelease( K_VK_ESCAPE ) ;
			break;
		}
		
		if ( StartGame==true)		
		{
			break ;
		}
		
		KGraphic::setWorldView( 0,0,0,1,true) ;
		
		SCR_DRAW();
		SCR_CLICK();
		
		surf_PointerS->blitAlphaRectFx( 0,0,32,32,mx+2,my+2,0,1,0.5f) ;
		
		if (CUR_BUT>0)
		{
			surf_Pointer2->blitAlphaRect( 0,0,32,32,mx,my) ;
		}
		else
		{
			surf_Pointer->blitAlphaRect( 0,0,32,32,mx,my) ;
		}
		//flips the backbuffer to display the rendering.
		KWindow::flipBackBuffer( true ) ;
		
	}while(KWindow::isQuit() == false ) ;

	freePointer();
//	delete ktext_font;
//	delete ktext_digifont;
	gameWindow->terminate() ;
	delete gameWindow ;
	KWindow::setPTKCallBack( NULL ) ; 
	
	KMiscTools::pause(100);
	
	//exit the game
	if (Finish==true) return 0;

	gameWindow = new KWindow ;
	if ( gameWindow == NULL )		
	{
		//uh oh a problem occured!
		return 0 ;
	}

	Finish=false;
	short i;

	if ( gameWindow->createGameWindow( 640,480,16,GV.Fullscreen,s ) == false )
	{
		//sorry couldn't create the window	
		delete gameWindow ;	
		return 0 ;
	}
	KWindow::setPTKCallBack( ourOwnEventCallback ) ; 
	CUR_SCR=2;
	SCR_INIT();

	//loads the font and initialize the table
	LoadPointer();
	KInput::hidePointer( ) ;
//	InitFont();
	ktext_font = new KText( KMiscTools::makeFilePath( "gfx\\fonts.png" ) , fontTable ) ;
    ktext_digifont  = new KText(KMiscTools::makeFilePath("gfx\\digifont.png"), fontTablePtr);
	//first hint
	if (!GV.Bought) StoryMsg=1;
	KInput::hidePointer( ) ;
#ifndef WIN32	
	HideMenuBar();
#endif	
	//game
	do
	{
		KGraphic::setDefaultWorldView( ) ; 
		short xMouse = KInput::getMouseX( ) ;
		short yMouse = KInput::getMouseY( ) ;

		if ( KInput::isPressed( K_VK_F12 ) == ISDOWN )
		{
			KInput::waitForKeyRelease( K_VK_F12 ) ; 
			KGraphic::saveBackBuffer( KMiscTools::makeFilePath( "screenshot.jpg" ) , K_IMAGE_JPG , 640,480) ;
		}
		
		//esc in BATTLE screen
		if ( KInput::isPressed( K_VK_ESCAPE ) == ISDOWN && CUR_SCR==5 && !ShowRepairW && !ShowBuyW && CTip<1 && StartFight!=1)
		{
			KInput::waitForKeyRelease( K_VK_ESCAPE  ) ;
			BattleOptions=!BattleOptions;
			if (!BattleOptions) ACT_BUT=4;
		}
		//esc in fight
		if ( KInput::isPressed( K_VK_ESCAPE ) == ISDOWN && CUR_SCR==6)
		{
			KInput::waitForKeyRelease( K_VK_ESCAPE  ) ;
			BattleOptions=!BattleOptions;
		}

		//fullscreen
		if ( KInput::isPressed( K_VK_F11 ) == ISDOWN )
		{
			KInput::waitForKeyRelease( K_VK_F11  ) ;
			GV.Fullscreen=!GV.Fullscreen;
			KWindow::toggleFullScreen(!GV.Fullscreen);
		}
		//tip
		if ( KInput::isPressed( K_VK_F1 ) == ISDOWN )
		{
			KInput::waitForKeyRelease( K_VK_F1 ) ; 
			CTip=1;
		}
		if ( KInput::isPressed( K_VK_F4 ) == ISDOWN )
		{
			SCR_INIT();
			KInput::waitForKeyRelease( K_VK_F4 ) ; 
		}

		if ( Finish==true)		break ;

		KGraphic::setWorldView( 0,0,0,1,true) ;
		SCR_DRAW();
		SCR_CLICK();

		if (CUR_SCR!=6)
		{
			if (SRepair==-2 && SBuyX==-2)
			{
				surf_PointerS->blitAlphaRectFx( 0,0,32,32,xMouse+2,yMouse+2,0,1,0.5f) ;
				if (CUR_BUT>0)
				{
					surf_Pointer2->blitAlphaRect( 0,0,32,32,xMouse,yMouse) ;
				}
				else
				{
					surf_Pointer->blitAlphaRect( 0,0,32,32,xMouse,yMouse) ;
				}
			}
			if (SRepair>-2)
			{
				if (SRepair==-1)
					DrawIMG(RPOINT,xMouse,yMouse,3);
				if (SRepair>-1)
					DrawIMG(RPOINT2,xMouse,yMouse,3);
			}
			if (SBuyX>-2)
			{
				if (SBuyX==-1)
					DrawIMG(BPOINT,xMouse,yMouse,3);
				if (SBuyX>-1)
					DrawIMG(BPOINT2,xMouse,yMouse,3);
			}
		}
		//flips the backbuffer to display the rendering.
		KWindow::flipBackBuffer( true );
	
	}while(KWindow::isQuit() == false ) ;
	
	if ( ktext_font != NULL ) 
	{ 
	 delete ktext_font ; 
	 ktext_font = NULL ; 
	} 
	//store info
	f=fopen(KMiscTools::makeFilePath("prefs"),"wb");
	if (f != NULL)
	{
		fwrite(&GV,sizeof(GV_t),1,f);
		fclose(f);
	}
 
	freePointer( ) ;
	FreeSounds ();
	//clear IMG array
	for ( i = 1 ; i < MY_MAX_GFX ; i++ )
	{
		if ( IMG[i].surface != NULL )	
		{
			delete	IMG[i].surface ;
			IMG[i].surface = NULL ;
		}
	}
	gameWindow->terminate() ;
	delete gameWindow ;
	KWindow::setPTKCallBack( NULL ) ; 
#ifndef WIN32	
	ShowMenuBar();
#endif	
	if (Options)
		KMiscTools::launchFile( KMiscTools::makeFilePath( "game.exe" )) ;
	if (isHelp)
		KMiscTools::launchURL( buyurl ) ;
	return 0 ;
}

//****************
//SCREEN_INIT
//****************
bool	SCR_INIT( void ) 
{
	int i,i2,c;
	short t1,t2;
	char s[StringValue];
	bool ok;
	//FILE	*f;
	CUR_BUT=0;PRV_BUT=-1;
	//clear GUIButtons array
	for ( i = 0 ; i < MAX_BUT ; i++ )
	{
		GUIButton[i].st=-1;
	}

	KGraphic::setGraphicQuality( false ) ;

	//choose screen
	switch	(CUR_SCR)
	{
	case 1://launcher screen
		//KSound::setGlobalVolumes( GV.MusicVolume=100,GV.SFXVolume=100 ) ;
		//KGraphic::setClearColor( 0,0,0,1 ) ;
		Timer=KMiscTools::getMilliseconds();
		LoadNewIMG(BACK,(char*)"gfx\\launcher.png",0);
		//SetGUIButton(1,5,305,21,23,30,185,1,1,BACK);
		SetGUIButton(1,40,310,15,15,30,195,1,1,BACK);
		SetGUIButton(2,40,310,15,15,30,225,-1,-1,BACK);
		SetGUIButton(3,40,310,15,15,210,195,1,1,BACK);
		SetGUIButton(4,40,310,15,15,210,225,-1,-1,BACK);
		SetGUIButton(5,69,304,100,30,149,257,1,1,BACK);
		ACT_BUT=6;
		break;
	//main menu
	case 2:
		StoryM=false;
		if ( IMG[BUYNOW].surface != NULL )	
		{
			delete	IMG[BUYNOW].surface ;
			IMG[BUYNOW].surface = NULL ;
		}
		if ( IMG[RESULT].surface != NULL )	
		{
			delete	IMG[RESULT].surface ;
			IMG[RESULT].surface = NULL ;
		}
		if (SND[MUSIC].sound == NULL)
		{
			SND[MUSIC].sound = new KSound ;
			SND[MUSIC].sound->loadStream( KMiscTools::makeFilePath( "snd\\theme.ogg")) ;
			SND[MUSIC].sound->playStream(false);
		}
		LoadNewIMG(PTK,(char*)"gfx\\PTK.tga",0);
		LoadNewIMG(MAIN,(char*)"gfx\\main.jpg",0);
		LoadNewIMG(BATTLE,(char*)"gfx\\battle.jpg",0);
		LoadNewIMG(SLIDER,(char*)"gfx\\slider.png",0);
		for(i=0;i<4;i++)
		{
			SetGUIButton(1+i,641,i*50,311,35,171,242+i*50,1,1,MAIN);
		}
		ACT_BUT=5;
		break;
	//choose team
	case 3:
		LoadNewIMG(SELECT,(char*)"gfx\\faction.jpg",0);
		SetGUIButton(1,640,0,165,165,414,6,1,1,SELECT);
		SetGUIButton(2,805,0,165,164,54,316,1,1,SELECT);
		SetGUIButton(3,640,164,175,29,0,0,1,1,SELECT);
		ACT_BUT=4;
		break;
	//squadron setup
	case 4:
		if ( IMG[SHIP].surface != NULL )	
		{
			delete	IMG[SHIP].surface ;
			IMG[SHIP].surface = NULL ;
		}
		if ( IMG[SELECT].surface != NULL )	
		{
			delete	IMG[SELECT].surface ;
			IMG[SELECT].surface = NULL ;
		}
		LoadNewIMG(WINDOW,(char*)"gfx\\window.jpg",0);
		//start game
		SetGUIButton(1,640,552,137,23,23,435,1,1,MAIN);
		//arrow for map selection
		SetGUIButton(2,951,143,31,29,25,211,1,1,MAIN);
		SetGUIButton(3,982,143,31,29,128,211,1,1,MAIN);
		for(i=0;i<2;i++)
		{
			SetGUIButton(4+i,766+i*89,185,68,50,185+i*89,268,1,1,MAIN);
		}
		SetGUIButton(6,967,0,53,60,381,284,1,1,MAIN);
		SetGUIButton(7,967,60,53,60,547,284,1,1,MAIN);
		SetGUIButton(8,967,120,18,18,175,98,1,1,MAIN);
		SetGUIButton(9,967,120,18,18,175,125,1,1,MAIN);
		SetGUIButton(10,967,120,18,18,175,152,1,1,MAIN);
		SetGUIButton(11,640,575,120,22,31,371,1,1,MAIN);
		SetGUIButton(12,640,601,120,22,31,397,1,1,MAIN);
		ACT_BUT=13;
		CurShip=1;CurMap=0;Budget=500;
		//demo mode?
		if (!GV.Bought) 
		{
			Budget=150;Advice=6;
			LoadNewIMG(DISABLED,(char*)"gfx\\disabled.png",0);
		}
		if (PlayerTeam==2)
		{
			_snprintf(s,16,"gfx\\b10.jpg");
			SetShip=10;
		}
		if (PlayerTeam==1)
		{
			_snprintf(s,16,"gfx\\r10.jpg");
			SetShip=20;
		}
		LoadNewIMG(SHIP,s,0);
		break;
	//battle
	case 5:
		SND[MUSIC].sound->stopStream(); 
		SND[MUSIC].sound->loadStream( KMiscTools::makeFilePath( "snd\\theme.ogg")) ;
		SND[MUSIC].sound->playStream(true);
		SetMap();
		//AI Choose & Place Ships (only if turn 0) and not story mode
		if (Turn==0 && StoryM==false)
		{	
			//buy and place the ships
			PlaceShips();
			Turn=1;
		}
		if ( IMG[MAIN].surface != NULL )	
		{
			delete	IMG[MAIN].surface ;
			IMG[MAIN].surface = NULL ;
		}
		if ( IMG[PLANET].surface != NULL )
		{
			delete	IMG[PLANET].surface ;
			IMG[PLANET].surface = NULL ;
		}
		LoadNewIMG(WINDOW,(char*)"gfx\\window.jpg",0);
		//repair mouse pointer
		LoadNewIMG(RPOINT,(char*)"gfx\\rpointer1.png",0);
		LoadNewIMG(RPOINT2,(char*)"gfx\\rpointer2.png",0);
		//buy mouse pointer
		LoadNewIMG(BPOINT,(char*)"gfx\\bpointer1.png",0);
		LoadNewIMG(BPOINT2,(char*)"gfx\\bpointer2.png",0);
		LoadNewIMG(BATTLE,(char*)"gfx\\battle.jpg",0);
		LoadNewIMG(SMALLS,(char*)"gfx\\ship-small.png",0);
		IMG[SMALLS].fw=50;IMG[SMALLS].fh=50;
		//end turn
		SetGUIButton(1,640,0,73,84,559,23,1,1,BATTLE);
		//repair
		SetGUIButton(2,640,90,73,48,559,113,1,1,BATTLE);
		//buy
		SetGUIButton(3,640,140,73,36,559,163,1,1,BATTLE);
		ACT_BUT=4;
		CleanUp=false;gMove=-1;DesX=-1;DesY=-1;StartFight=-1;Fightship1=-1;Fightship2=-1;BattleOptions=false;
		//if ship=-1 put it out of the screen! :)
		for(i=0;i<10;i++)
		{
			if(Squad[0].ship[i]==-1)
				Squad[0].shipx[i]=-1;
			if(Squad[1].ship[i]==-1)
				Squad[1].shipx[i]=-1;
		}
		//if was moving the pc, resume play
		if (AIMove==true)
				AIMovement();
		break;
	//FIGHT!
	case 6:
		SND[MUSIC].sound->stopStream(); 
		SND[MUSIC].sound->loadStream( KMiscTools::makeFilePath( "snd\\battle.ogg")) ;
		SND[MUSIC].sound->playStream(true);
		InitFight();
		break;
	//Story Mode Screen
	case 7:
		//quit
		if (PlayerTeam==1)
		{
			SetGUIButton(1,265,960,265,41,355,430,1,1,SELECT);
			CurMission=GV.StoryLevelRed;
		}
		if (PlayerTeam==2)
		{
			SetGUIButton(1,0,960,265,41,355,430,1,1,SELECT);
			CurMission=GV.StoryLevelBlue;
		}
		ACT_BUT=2;
		break;
	//Result Screen
	case 8:
		SND[MUSIC].sound->stopStream(); 
		SND[MUSIC].sound->loadStream( KMiscTools::makeFilePath( "snd\\theme.ogg")) ;
		SND[MUSIC].sound->playStream(true);
		LoadNewIMG(RESULT,(char*)"gfx\\result.jpg",0);
		break;
	//BuyNow!
	case 9:
		LoadNewIMG(BUYNOW,(char*)"gfx\\buynow.jpg",0);
		break;
	//end of campaign!
	case 10:
		if (PlayerTeam==2)
			LoadNewIMG(BUYNOW,(char*)"gfx\\endblue.jpg",0);
		if (PlayerTeam==1)
			LoadNewIMG(BUYNOW,(char*)"gfx\\endred.jpg",0);
		break;
	}
return true;
}



//****************
//SCREEN_DRAW
//****************
void	SCR_DRAW( void ) 
{
	short i;
	char s[512];
	switch	(CUR_SCR)
	{
	case 1:
		DrawLauncher();
		break;
	case 2:
		DrawMain();
		break;
	case 3:
		DrawSelect();
		break;
	case 4:
		DrawSetup();
		break;
	case 5:
		DrawBattle();
		break;
	case 6:
		DrawFight();
		break;
	case 7:
		DrawStory();
		break;
	case 8:
		DrawResult();
		break;
	case 9:
		DrawIMG(BUYNOW,0,0,1);
		break;
	case 10:
		DrawIMG(BUYNOW,0,0,1);
		if (PlayerTeam==1)
			ktext_font->drawMultiLine( "Good job, Commander!\n \nYou have defeated the pathetic Blue Army and secured this galaxy!\nNow we can start to \"claim\" some of those planets resources and make their populations \"friendly\" toward us without any opposition.\n \nBut now my friend, come: our comrades await us to start celebrating one of our greatest victories ever!",10,630,320,2) ;
		if (PlayerTeam==2)
			ktext_font->drawMultiLine( "Let's celebrate together, Brother!\n \nYou have defeated the evil Red Legion and saved this galaxy from their domain!\nNow we can start a peaceful relationship with all the people which we saved, to build a better world.\n \n You'll be remembered for a long time as the Greatest Brother, and you'll be part of the Great Council from now on!",10,630,320,2) ;
		break;
	}
	//show window
	if (Advice>0)
		ShowAdvice();
	//show coordinates
	if (Show_XY==true)
	{
		mx = KInput::getMouseX( ) ;
		my = KInput::getMouseY( ) ;
		ktext_font->drawStringCentered( mx ,0,100,33) ;
		ktext_font->drawStringCentered( my ,100,130,33) ;
		ktext_font->drawStringCentered( CUR_BUT ,150,200,33) ;
	}
}

//****************
//SCREEN_CLICK
//****************
void	SCR_CLICK( void ) 
{
	char s[256];
	short i,i2,c,i3;
	bool ok,ok2;
	ButtDown = KInput::getLeftButtonState( );
	mx = KInput::getMouseX( ) ;
	my = KInput::getMouseY( ) ;
	//msg window?
	if (Advice>0)
	{
		//if (GV.Tutorial==false) GV.Tutorial=true;
		if (Inside(mx,my,159,397,479,423) && ButtDown)
		{
			waitForMouseButton();snd_Click->playSample();
			Advice=0;
		}
		return;
	}

  //controlla se  su un pulsante
	if (CUR_BUT>0) PRV_BUT=CUR_BUT;
	CUR_BUT=0;
	if (ACT_BUT>0)
	{
		for ( i = 1 ; i < ACT_BUT ; i++ ) 
		{
			if (mx >= GUIButton[i].ox && mx<=GUIButton[i].ox + GUIButton[i].w && my>=GUIButton[i].oy && my<=GUIButton[i].oy + GUIButton[i].h && GUIButton[i].st>-1)
			{
				CUR_BUT=i;
				if ( CUR_BUT!=PRV_BUT ) snd_Over->playSample();
				break;
			}
		}
	}
	//screenshot
	if ( KInput::isPressed( K_VK_F12 ) == ISDOWN )
		KGraphic::saveBackBuffer( KMiscTools::makeFilePath( "screenshot.jpg" ),K_IMAGE_JPG ) ;

	//interactive placement of buttons
	if (Interactive_GUI==true)
	{
		if (ButtDown && CUR_BUT>0)
		{
			GUIButton[CUR_BUT].ox=mx-GUIButton[CUR_BUT].w/2;
			GUIButton[CUR_BUT].oy=my-GUIButton[CUR_BUT].h/2;
		}
		if (KInput::getRightButtonState())
		{
			FILE	*f;
			char	s[255];
			i=sprintf(s,"data\\GUI%d",CUR_SCR);
			f=fopen(KMiscTools::makeFilePath(s),"w");
			if (f != NULL)
			{
				fwrite( GUIButton , sizeof(GUIButton_t)*ACT_BUT ,1 ,f );
				fclose(f);
			}
		}
		return;
	}

	//get clicks
	switch	(CUR_SCR)
	{
	//launcher menu
	case 1:
		if (Inside(mx,my,155,99,370,123) && ButtDown)
		{
			waitForMouseButton();
			ActInput=0;bufferPosition=0;
		}
		if (Inside(mx,my,155,130,370,150) && ButtDown)
		{
			waitForMouseButton();
			ActInput=1;bufferPosition=0;
		}
		if (CUR_BUT==5 && ButtDown)
		{
			snd_Click->playSample();
			waitForMouseButton();
			CheckCode(thesavedcode.nom,thesavedcode.code);
			StartGame=true;Finish=false;
		}
		if (CUR_BUT>0 && CUR_BUT<5 && ButtDown)
		{
			snd_Click->playSample();
			waitForMouseButton();
			if (CUR_BUT==1)
			{
				if (GV.Depth==true)
				{
					GV.Depth=false;
				}
				else
				{
					GV.Depth=true;
				}
			}
			if (CUR_BUT==3)
			{
				if (GV.Fullscreen==true)
				{
					GV.Fullscreen=false;
				}
				else
				{
					GV.Fullscreen=true;
				}
			}
		}
		break;
	//main
	case 2:
		ClickMain();
		break;
	//select
	case 3:
		ClickSelect();
		break;
	//setup
	case 4:
		ClickSetup();
		break;
	case 5:
		ClickBattle();
		break;
	case 6:
		ClickFight();
		break;
	case 7:
		ClickStory();
		break;
	case 8:
		ClickResult();
		break;
	case 9:
		if (ButtDown)
		{
			if(!Inside(mx,my,140,450,500,480))
				isHelp=true;
			Finish=true;
		}
		break;
	case 10:
		if (ButtDown)
		{
			CUR_SCR=2;
			SCR_INIT();
		}
		break;
	}
}

void	freePointer( void ) 
{
	delete surf_Pointer ;
	delete surf_Pointer2 ;
	delete surf_PointerS ;
}

void SetFontItem(int index, char c, KFont& f)
{
    KIniReader iniReader;
    iniReader.setIni(KMiscTools::makeFilePath("font.ini"));
    
    char cid[16];
    char buff[24];
    sprintf(cid, "%d", index);
    iniReader.getString("Char Widths", cid, buff, 24);
    
    int w = atoi(buff);
    
    f._w = w;
    f._c = c;
    f._h = 14;
    f._x1 = (index % 16) * 16;
    f._y1 = 1+(index / 16) * 16;
    f._x2 = f._x1 + w;
    f._y2 += f._y1 + 16;
}

void InitFont()
{

    //ZeroMemory(fontTablePtr, sizeof(KFont) * 128);
    
    char characters [] = { ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '\'', ',', '-', '.', '/',
                              '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
                              '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
                                'P','Q','R','S','T','U','V','W','X','Y','Z','[','\\',']','^','_',
                                '`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
                                'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~', '\0' };



    int i = 0;
    while (characters[i] != '\0')
    {
        SetFontItem(i, characters[i], fontTablePtr[i]);
        ++i;
    }
   
	ktext_font = new KText( KMiscTools::makeFilePath( "gfx\\fonts.png" ) , fontTable ) ;
    ktext_digifont  = new KText(KMiscTools::makeFilePath("gfx\\digifont.png"), fontTablePtr);
}

void PlaceShips(void)
{
	short i=0,r=0,s=1,i2=0;
	short m=500;
	bool ok=false;
	//buy ships
	do
	{
		r=2+rand()%9;
		if (PlayerTeam==2)
			r+=10;
		//check money
		if (Ship[r].cost<=m)
		{
			//different ship
			if (s>0)
			{
				if (r!=Squad[1].ship[s-1])
				{
					Squad[1].ship[s]=r;m-=r;Squad[1].shipHP[s]=Ship[r].hp;s++;
				}
			}
			if (s==0)
			{
				Squad[1].ship[s]=r;m-=r;Squad[1].shipHP[s]=Ship[r].hp;s++;
			}
		}
		if(s>9) ok=true;
	}while (ok==false);
	//now place them
	for(i=0;i<s;i++)
	{
		//computer red
		if (PlayerTeam==2)
		{
			if (i==0)
			{
				Squad[1].shipx[i]=5;Squad[1].shipy[i]=0;
			}
			if (i==1)
			{
				Squad[1].shipx[i]=10;Squad[1].shipy[i]=0;
			}
			if (i==2)
			{
				Squad[1].shipx[i]=0;Squad[1].shipy[i]=0;
			}
			if (i>2)
			{
				ok=false;
				do
				{
					Squad[1].shipx[i]=1+rand()%8;
					Squad[1].shipy[i]=rand()%2;
					ok=true;
					for(i2=0;i2<i;i2++)
					{
						if(Squad[1].shipx[i2]==Squad[1].shipx[i] && Squad[1].shipy[i2]==Squad[1].shipy[i])
							ok=false;
					}
				}while(ok==false);
			}
		}
		else
		//computer blue
		{
			if (i==0)
			{
				Squad[1].shipx[i]=5;Squad[1].shipy[i]=8;
			}
			if (i==1)
			{
				Squad[1].shipx[i]=0;Squad[1].shipy[i]=8;
			}
			if (i==2)
			{
				Squad[1].shipx[i]=10;Squad[1].shipy[i]=8;
			}
			if (i>2)
			{
				ok=false;
				do
				{
					Squad[1].shipx[i]=1+rand()%8;
					Squad[1].shipy[i]=7+rand()%2;
					ok=true;
					for(i2=0;i2<i;i2++)
					{
						if(Squad[1].shipx[i2]==Squad[1].shipx[i] && Squad[1].shipy[i2]==Squad[1].shipy[i])
							ok=false;
					}
				}while(ok==false);
			}

		}
	}
}

bool	ourOwnEventCallback( KEvent	*eventPtr ) 
{
	lastchar=0;
	//this should never happen, but better make sure...
	if ( eventPtr == NULL )		return false ;

	switch( eventPtr->type )
	{
		case	K_EVENT_MOUSEMOVE:
			mousx = eventPtr->mouseX ;
			mousy = eventPtr->mouseY ;
		break;
		case	K_EVENT_CHAR:
			lastchar = eventPtr->character ;
			if (lastchar==13)
				lastchar=0;
			return false;
		break;
		
	}
	return true;

}

void InitFight(void)
{
	short i,i2;
	char s[512];
	if ( IMG[BATTLE].surface != NULL )	
	{
		delete	IMG[BATTLE].surface ;
		IMG[BATTLE].surface = NULL ;
	}
	if ( IMG[SMALLS].surface != NULL )
	{
		delete	IMG[SMALLS].surface ;
		IMG[SMALLS].surface = NULL ;
	}
	if ( IMG[SHIP1].surface != NULL )
	{
		delete	IMG[SHIP1].surface ;
		IMG[SHIP1].surface = NULL ;
	}
	if ( IMG[SHIP2].surface != NULL )
	{
		delete	IMG[SHIP2].surface ;
		IMG[SHIP2].surface = NULL ;
	}
	//clear weapons
	for(i=0;i<3;i++)
	{
		if ( IMG[SHIP1W1+i].surface != NULL )	
		{
			delete	IMG[SHIP1W1+i].surface ;
			IMG[SHIP1W1+i].surface = NULL ;
		}
		if ( IMG[SHIP2W1+i].surface != NULL )	
		{
			delete	IMG[SHIP2W1+i].surface ;
			IMG[SHIP2W1+i].surface = NULL ;
		}
	}
	//display keys
	LoadNewIMG(KEYS,"gfx\\keys.jpg",0);
	if (rand()%5>2)
	{
		LoadNewIMG(PLANET,"gfx\\starfield1.jpg",0);
	}
	else
	{
		LoadNewIMG(PLANET,"gfx\\starfield2.jpg",0);
	}
	LoadNewIMG(PANELS,(char*)"gfx\\panels.png",0);
	LoadNewIMG(FX01,(char*)"gfx\\vortex.png",0);
	LoadNewIMG(EXPLODE01,(char*)"gfx\\explode01.png",0);
	IMG[EXPLODE01].fw=102;IMG[EXPLODE01].fh=70;
	LoadNewIMG(EXPLODE02,(char*)"gfx\\explode02.png",50);
	IMG[EXPLODE02].fw=128;IMG[EXPLODE02].fh=128;
	LoadNewIMG(LIMITERS,(char*)"gfx\\limiters.png",0);
	IMG[LIMITERS].fw=84;IMG[LIMITERS].fh=84;
	//place limiters
	for(i=0;i<15;i++)
	{
		Limiter[i].id=1;Limiter[i].x=200+i*90;Limiter[i].y=150;
		Limiter[i+15].id=4;Limiter[i+15].x=200+i*90;Limiter[i+15].y=1480;
		Limiter[i+30].id=6;Limiter[i+30].x=115;Limiter[i+30].y=150+i*89;
		Limiter[i+45].id=7;Limiter[i+45].x=1553;Limiter[i+45].y=149+i*89;
	}
	Limiter[30].id=0;Limiter[45].id=2;Limiter[45].x=1550;
	Limiter[60].id=3;Limiter[60].x=115;Limiter[60].y=1480;
	Limiter[61].id=5;Limiter[61].x=1550;Limiter[61].y=1480;

	ACT_BUT=0;
	//load render of ship, ship1 is always the player
	if (PlayerTeam==2)
	{
		_snprintf(s,32,"gfx\\blueship%02d.png",Ship[Squad[0].ship[Fightship1]].id);
		LoadNewIMG(SHIP1,s,0);
		_snprintf(s,32,"gfx\\redship%02d.png",Ship[Squad[1].ship[Fightship2]].id);
		LoadNewIMG(SHIP2,s,0);
		//load weapons
		for(i=0;i<3;i++)
		{
			if (Ship[Squad[0].ship[Fightship1]].At[i]>0)
			{
				_snprintf(s,32,"gfx\\blueship%02dw%d.png",Ship[Squad[0].ship[Fightship1]].id,i+1);
				LoadNewIMG(SHIP1W1+i,s,0);
			}
			if (Ship[Squad[1].ship[Fightship2]].At[i]>0)
			{
				_snprintf(s,32,"gfx\\redship%02dw%d.png",Ship[Squad[1].ship[Fightship2]].id,i+1);
				LoadNewIMG(SHIP2W1+i,s,0);
			}
		}
	}
	else
	{
		_snprintf(s,32,"gfx\\redship%02d.png",Ship[Squad[0].ship[Fightship1]].id);
		LoadNewIMG(SHIP1,s,0);
		_snprintf(s,32,"gfx\\blueship%02d.png",Ship[Squad[1].ship[Fightship2]].id);
		LoadNewIMG(SHIP2,s,0);
		//load weapons
		for(i=0;i<3;i++)
		{
			if (Ship[Squad[0].ship[Fightship1]].At[i]>0)
			{
				_snprintf(s,32,"gfx\\redship%02dw%d.png",Ship[Squad[0].ship[Fightship1]].id,i+1);
				LoadNewIMG(SHIP1W1+i,s,0);
			}
			if (Ship[Squad[1].ship[Fightship2]].At[i]>0)
			{
				_snprintf(s,32,"gfx\\blueship%02dw%d.png",Ship[Squad[1].ship[Fightship2]].id,i+1);
				LoadNewIMG(SHIP2W1+i,s,0);
			}
		}
	}
	//load bonuses
	for(i=0;i<3;i++)
	{
		_snprintf(s,24,"gfx\\bonus%d.png",i+1);
		LoadNewIMG(BONUS01+i,s,0);
	}
	//ship 0 is player
	AShip[0].d=0;AShip[0].s=0;AShip[0].x=256-IMG[SHIP1].w/2;AShip[0].y=240-IMG[SHIP1].h/2;AShip[0].wr[0]=0;AShip[0].wr[1]=0;AShip[0].wr[2]=0;
	AShip[1].d=180;AShip[1].s=0;AShip[1].x=160-IMG[SHIP2].w/2;AShip[1].y=160-IMG[SHIP2].h/2;AShip[1].wr[0]=0;AShip[1].wr[1]=0;AShip[1].wr[2]=0;
	AShip[0].defence=0;AShip[0].speed=0;AShip[0].power=0;AShip[1].defence=0;AShip[1].speed=0;AShip[1].power=0;
	BOffSetX=EDGE_X-160;BOffSetY=EDGE_Y-160;SRepair=-2;ShowRepairW=false;SBuyX=-2;ShowBuyW=false;Reflect1=0;Reflect2=0;
	for(i=0;i<100;i++)
	{
		Bullet[i].lf=-1;
	}
	for(i=0;i<15;i++)
	{
		Explosion[i].lf=-1;
	}
	for(i=0;i<50;i++)
	{
		Bonus[i].id=-1;
	}
	//load stars
	for(i=0;i<5;i++)
	{
		_snprintf(s,16,"gfx\\star%d.png",i);
		LoadNewIMG(STAR00+i,s,0);
	}
	//generate stars
	for(i=0;i<MAX_STARS;i++)
	{
		BStar[i].x=rand()%(EDGE_X+640);BStar[i].y=rand()%(EDGE_Y+480);
		BStar[i].d=rand()%4;BStar[i].id=rand()%5;
		if (rand()%40>3)
			BStar[i].d=2+rand()%2;
		if (rand()%20>3)
			BStar[i].id=0;
	}
	//load asteroids
	for(i=0;i<4;i++)
	{
		_snprintf(s,24,"gfx\\asteroid%d.png",i+1);
		LoadNewIMG(ASTER00+i,s,0);
	}
	IMG[ASTER00].fw=60;IMG[ASTER00].fh=60;
	IMG[ASTER01].fw=62;IMG[ASTER01].fh=57;
	IMG[ASTER02].fw=38;IMG[ASTER02].fh=38;
	IMG[ASTER03].fw=47;IMG[ASTER03].fh=43;
	//generate asteroids
	i2=0;
	for(i=0;i<10;i++)
	{
		if (Planet[i].x==Squad[0].shipx[Fightship1] && Planet[i].y==Squad[0].shipy[Fightship1])
			i2=Planet[i].spd;
	}
	for(i=0;i<50;i++)
	{
		Asteroid[i].id=-1;
	}
	for(i=0;i<5+i2;i++)
	{
		Asteroid[i].x=rand()%EDGE_X-640;Asteroid[i].y=rand()%EDGE_Y-480;Asteroid[i].d=rand()%360;Asteroid[i].frame=0;
		Asteroid[i].id=rand()%4;Asteroid[i].hp=15+rand()%100;Asteroid[i].s=(float)(1+rand()%11)/10;
	}
	//load minerals
	for(i=0;i<3;i++)
	{
		_snprintf(s,24,"gfx\\mineral%d.png",i+1);
		LoadNewIMG(MINERAL01+i,s,0);
		IMG[MINERAL01+i].fh=20;IMG[MINERAL01+i].fw=20;
	}
	//generate minerals
	for(i=0;i<16;i++)
	{
		Mineral[i].id=-1;
		if (rand()%5>3)
		{
			Mineral[i].id=rand()%3;Mineral[i].x=300+rand()%(EDGE_X-750);Mineral[i].y=300+rand()%(EDGE_Y-750);Mineral[i].taken=false;
		}
	}
	
	tmpWeap=0;SpinRay1=0;SpinRay2=0;
}

void SetMap(void)
{
	//set map
	switch(CurMap)
	{
	case 0:
		Planet[0].x=5;Planet[0].y=4;Planet[0].type=2;Planet[0].credits=7;
		Planet[1].x=0;Planet[1].y=0;Planet[1].type=3;Planet[1].credits=3;Planet[1].spd=25;
		Planet[2].x=0;Planet[2].y=8;Planet[2].type=3;Planet[2].credits=3;Planet[2].spd=25;
		Planet[3].x=10;Planet[3].y=0;Planet[3].type=1;Planet[3].credits=1;Planet[3].spd=15;
		Planet[4].x=10;Planet[4].y=8;Planet[4].type=1;Planet[4].credits=1;Planet[4].spd=15;
//		Guardian[0].hp=500;Guardian[0].x=5;Guardian[0].y=4;
		break;
	case 1:
		Planet[0].x=5;Planet[0].y=0;Planet[0].type=2;Planet[0].credits=7;Planet[0].spd=7;
		Planet[1].x=5;Planet[1].y=8;Planet[1].type=2;Planet[1].credits=7;Planet[1].spd=7;
		Planet[2].x=0;Planet[2].y=4;Planet[2].type=1;Planet[2].credits=1;Planet[0].spd=5;
		Planet[3].x=10;Planet[3].y=4;Planet[3].type=1;Planet[3].credits=1;Planet[0].spd=5;
		Planet[4].x=5;Planet[4].y=4;Planet[4].type=3;Planet[4].credits=3;Planet[0].spd=10;
/*		Guardian[0].hp=500;Guardian[0].x=0;Guardian[0].y=4;
		Guardian[1].hp=500;Guardian[1].x=5;Guardian[1].y=4;
		Guardian[2].hp=500;Guardian[2].x=10;Guardian[2].y=4;
*/		break;
	case 2:
		Planet[0].x=6;Planet[0].y=3;Planet[0].type=1;Planet[0].credits=3;Planet[0].spd=10;
		Planet[1].x=6;Planet[1].y=5;Planet[1].type=1;Planet[1].credits=3;Planet[1].spd=10;
		Planet[2].x=4;Planet[2].y=3;Planet[2].type=3;Planet[2].credits=7;Planet[0].spd=15;
		Planet[3].x=4;Planet[3].y=5;Planet[3].type=3;Planet[3].credits=7;Planet[0].spd=15;
		Planet[4].x=5;Planet[4].y=4;Planet[4].type=2;Planet[4].credits=15;
//		Guardian[0].hp=500;Guardian[0].x=5;Guardian[0].y=4;
		break;
	case 3:
		Planet[0].x=5;Planet[0].y=2;Planet[0].type=2;Planet[0].credits=5;
		Planet[1].x=0;Planet[1].y=0;Planet[1].type=3;Planet[1].credits=2;Planet[1].spd=25;
		Planet[2].x=0;Planet[2].y=8;Planet[2].type=3;Planet[2].credits=2;Planet[2].spd=25;
		Planet[3].x=10;Planet[3].y=0;Planet[3].type=1;Planet[3].credits=1;Planet[3].spd=15;
		Planet[4].x=10;Planet[4].y=8;Planet[4].type=1;Planet[4].credits=1;Planet[4].spd=15;
		Planet[5].x=5;Planet[5].y=6;Planet[5].type=2;Planet[5].credits=5;
		Planet[6].x=3;Planet[6].y=4;Planet[6].type=2;Planet[6].credits=5;
		Planet[7].x=7;Planet[7].y=4;Planet[7].type=2;Planet[7].credits=5;
		break;
	}
}